<?php
// backend/api/add_task.php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../config/db.php';

// Get raw posted data
$data = json_decode(file_get_contents("php://input"));

if (!empty($data->title)) {
    try {
        $query = "INSERT INTO tasks (title, description) VALUES (:title, :description)";
        $stmt = $conn->prepare($query);

        $title = htmlspecialchars(strip_tags($data->title));
        $description = isset($data->description) ? htmlspecialchars(strip_tags($data->description)) : '';

        $stmt->bindParam(":title", $title);
        $stmt->bindParam(":description", $description);

        if ($stmt->execute()) {
            http_response_code(201); // Created
            echo json_encode(["status" => "success", "message" => "Task was created."]);
        } else {
            http_response_code(503); // Service Unavailable
            echo json_encode(["status" => "error", "message" => "Unable to create task."]);
        }
    } catch (PDOException $e) {
        http_response_code(500); 
        echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
    }
} else {
    http_response_code(400); // Bad Request
    echo json_encode(["status" => "error", "message" => "Incomplete data. Title is required."]);
}
?>
