<?php
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// CORS headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once 'db_connect.php';

try {
    // Accept BOTH GET and POST
    $sender_id  = $_POST['sender_id'] ?? $_GET['sender_id'] ?? null;
    $reciver_id = $_POST['reciver_id'] ?? $_GET['reciver_id'] ?? null;

    error_log("checkrequest.php - sender_id: $sender_id, reciver_id: $reciver_id");

    if (!$sender_id || !$reciver_id) {
        echo json_encode([
            "status" => "error", 
            "message" => "Missing params"
        ]);
        exit;
    }

    // Check for existing request (only Pending or Accepted, Rejected are deleted)
    $stmt = $conn->prepare("
        SELECT * FROM user_requests
        WHERE (sender_id = ? AND reciver_id = ?)
           OR (sender_id = ? AND reciver_id = ?)
        LIMIT 1
    ");

    if (!$stmt) {
        throw new Exception("Database error: " . $conn->error);
    }

    $stmt->bind_param("iiii", $sender_id, $reciver_id, $reciver_id, $sender_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo json_encode(["status" => "none"]);
    } else {
        echo json_encode([
            "status" => "found", 
            "data" => $result->fetch_assoc()
        ]);
    }

    $stmt->close();
    $conn->close();

} catch (Exception $e) {
    error_log("checkrequest.php Error: " . $e->getMessage());
    echo json_encode([
        "status" => "error",
        "message" => "Internal server error"
    ]);
}
?>