<?php
require_once 'cors.php';
require 'db_connect.php';
header('Content-Type: application/json');

$user_id = $_GET['user_id'] ?? null;

if (!$user_id) {
    echo json_encode(["status" => "error", "message" => "Missing user_id"]);
    exit;
}

$stmt = $conn->prepare("
    SELECT 
        req.id,
        us.user_name AS sender_name,
        ur.user_name AS reciver_name,
        req.sender_id,
        req.reciver_id,
        req.request_status,
        req.entry_date_time
    FROM user_requests req
    JOIN users us ON us.id = req.sender_id
    JOIN users ur ON ur.id = req.reciver_id
    WHERE req.sender_id = ? OR req.reciver_id = ?
");
$stmt->bind_param("ii", $user_id, $user_id);
$stmt->execute();
$result = $stmt->get_result();

$requests = [];
while ($row = $result->fetch_assoc()) {
    $requests[] = $row;
}

echo json_encode(["status" => "success", "data" => $requests]);
?>
