<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

// Error reporting on karein
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'db_config.php';

// Check connection manually
if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}

$conn->set_charset("utf8mb4");

// Pehle check karein ke table mein data hai bhi ya nahi
$check = $conn->query("SELECT COUNT(*) as total FROM ibaadat_data");
$row_count = $check->fetch_assoc();

if($row_count['total'] == 0) {
    echo json_encode(["message" => "Database table is empty. Please run insert_data.php first."]);
    exit;
}

// Testing ke liye: Baghair category ke saara data uthao
$sql = "SELECT title, arabic_text as arabicText, translation, description, note, image_url as imageUrl FROM ibaadat_data";

$result = $conn->query($sql);
$data = array();

if ($result) {
    while($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(["error" => "Query Error: " . $conn->error]);
}
?>