<?php
include 'db_config.php';

// Database ko connection ke waat hi batana ke hum Arabic use karenge
$conn->set_charset("utf8mb4");

// Purana kharab data delete karein
$conn->query("TRUNCATE TABLE ibaadat_data");

$base_url = "https://huzaifatech.site/api/islam_hub/assets/";

$ibaadat_content = [
    ['Prayer', 'Wazoo ka Tareeqa', '', '', 'Bismillah parh kar hath dhoein, kulli karein...', 'Wazoo lazmi hai', $base_url.'wazoo.jpg'],
    ['Prayer', 'Takbeer-e-Tahreema', 'اللَّهُ أَكْبَرُ', 'Allah is Greatest', 'Dono hath kaano tak uthayein...', 'Aaghaz', $base_url.'takbeer.jpg'],
    ['Prayer', 'Sana', 'سُبْحَانَكَ اللَّهُمَّ وَبِحَمْدِكَ وَتَبَارَكَ اسْمُكَ', 'Glory be to You Allah...', 'Pehli dua...', '', $base_url.'qiyam.jpg'],
    ['Prayer', 'Ruku', 'سُبْحَانَ رَبِّيَ الْعَظِيمِ', 'Glory to my Lord...', 'Jhuk kar parhein...', '', $base_url.'ruku.jpg'],
    ['Prayer', 'Sajda', 'سُبْحَانَ رَبِّيَ الْأَعْلَىٰ', 'Glory to my Lord Highest...', 'Sajde mein parhein...', '', $base_url.'sajda.jpg'],
    ['Prayer', 'Tashahhud', 'التَّحِيَّاتُ لِلَّهِ...', 'All compliments to Allah...', 'Baith kar parhein', '', $base_url.'tashood.jpg'],
    ['Prayer', 'Salam', 'السَّلَامُ عَلَيْكُمْ وَرَحْمَةُ اللَّهِ', 'Peace be upon you...', 'Namaz khatam karein', '', $base_url.'salam.jpg']
];

// Dhayan dein: yahan 7 columns hain aur 7 's' (sssssss) hain
$stmt = $conn->prepare("INSERT INTO ibaadat_data (category, title, arabic_text, translation, description, note, image_url) VALUES (?, ?, ?, ?, ?, ?, ?)");

foreach ($ibaadat_content as $item) {
    $stmt->bind_param("sssssss", $item[0], $item[1], $item[2], $item[3], $item[4], $item[5], $item[6]);
    $stmt->execute();
}

echo "Backend Cleaned and Updated with Arabic and Images!";
?>