<?php
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// CORS headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Include database
require_once 'db_connect.php';

try {
    // Get POST data
    $request_id = $_POST['request_id'] ?? null;
    $status = $_POST['status'] ?? null;
    $reciver_id = $_POST['reciver_id'] ?? null;

    error_log("respondRequest.php - request_id: $request_id, status: $status, reciver_id: $reciver_id");

    if (!$request_id || !$status || !$reciver_id) {
        echo json_encode([
            "status" => "error",
            "message" => "Missing params"
        ]);
        exit;
    }

    // Validate status
    if (!in_array($status, ['Accepted', 'Rejected'])) {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid status"
        ]);
        exit;
    }

    // If status is Rejected, DELETE the request instead of updating
    if ($status === 'Rejected') {
        $stmt = $conn->prepare("DELETE FROM user_requests WHERE id = ?");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }

        $stmt->bind_param("i", $request_id);
        
        if ($stmt->execute()) {
            echo json_encode([
                "status" => "success",
                "message" => "Request deleted successfully"
            ]);
        } else {
            throw new Exception("Delete failed: " . $stmt->error);
        }
        
        $stmt->close();
    } 
    // If status is Accepted, UPDATE the request
    else {
        $stmt = $conn->prepare("
            UPDATE user_requests 
            SET request_status = ? 
            WHERE id = ?
        ");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }

        $stmt->bind_param("si", $status, $request_id);
        
        if ($stmt->execute()) {
            echo json_encode([
                "status" => "success",
                "message" => "Request updated successfully"
            ]);
        } else {
            throw new Exception("Update failed: " . $stmt->error);
        }
        
        $stmt->close();
    }

    $conn->close();

} catch (Exception $e) {
    error_log("respondRequest.php Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Internal server error"
    ]);
}
?>