<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

include 'db_connect.php';

$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data || !is_array($data)) {
    if (!empty($_POST)) {
        $data = $_POST;
    } else {
        parse_str($raw, $data);
    }
}

$name     = isset($data['name']) ? trim($data['name']) : '';
$email    = isset($data['email']) ? trim($data['email']) : '';
$password = isset($data['password']) ? trim($data['password']) : '';
$contact  = isset($data['contact']) ? trim($data['contact']) : '';

if (empty($name) || empty($email) || empty($password) || empty($contact)) {
    echo json_encode(["status" => "error", "message" => "All fields are required"]);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(["status" => "error", "message" => "Invalid email"]);
    exit;
}

// ✅ SECURE VERSION - Prepared Statement Use Karo
$check_stmt = $conn->prepare("SELECT id FROM mobile WHERE email = ?");
$check_stmt->bind_param("s", $email);
$check_stmt->execute();
$check_stmt->store_result();

if ($check_stmt->num_rows > 0) {
    echo json_encode(["status" => "error", "message" => "Email already exists"]);
    $check_stmt->close();
    exit;
}
$check_stmt->close();

// ✅ SECURE INSERT
$hashed = password_hash($password, PASSWORD_DEFAULT);
$insert_stmt = $conn->prepare("INSERT INTO mobile (name, email, password, contact) VALUES (?, ?, ?, ?)");
$insert_stmt->bind_param("ssss", $name, $email, $hashed, $contact);

if ($insert_stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "User registered successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Database error: " . $insert_stmt->error]);
}

$insert_stmt->close();
$conn->close();
?>