-- Database Creation
CREATE DATABASE IF NOT EXISTS todo_app;
USE todo_app;

-- Tasks Table Creation
CREATE TABLE IF NOT EXISTS tasks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    is_completed TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Sample Data (Optional)
INSERT INTO tasks (title, description, is_completed) VALUES 
('Buy Groceries', 'Milk, Bread, Eggs', 0),
('Learn Flutter', 'Complete the Todo App tutorial', 0),
('Backend Setup', 'Upload PHP files to hosting', 1);
