<?php
// backend/api/get_tasks.php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../config/db.php';

try {
    $query = "SELECT * FROM tasks ORDER BY created_at DESC";
    $stmt = $conn->prepare($query);
    $stmt->execute();

    $num = $stmt->rowCount();

    if ($num > 0) {
        $tasks_arr = array();
        $tasks_arr["status"] = "success";
        $tasks_arr["data"] = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            // Extract row to variables
            extract($row);

            $task_item = array(
                "id" => $id,
                "title" => $title,
                "description" => $description,
                "is_completed" => $is_completed, // 0 or 1
                "created_at" => $created_at
            );

            array_push($tasks_arr["data"], $task_item);
        }

        http_response_code(200);
        echo json_encode($tasks_arr);
    } else {
        http_response_code(200); // OK, but empty
        echo json_encode(["status" => "success", "data" => [], "message" => "No tasks found."]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
}
?>
