<?php
session_start();

// Database connection
$servername = "localhost";
$username   = "root";   // change if needed
$password   = "";    // change if needed
$database   = "huzafzif_islam";

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("❌ Database Connection Failed: " . $conn->connect_error);
}

// Folder for uploads
$upload_dir = "uploads/";
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

$message = "";

// -------------------- SIGNUP --------------------
if (isset($_POST['signup'])) {
    $name     = trim($_POST['name']);
    $email    = trim($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    if (!empty($_FILES['file']['name'])) {
        $file_name = basename($_FILES['file']['name']);
        $file_tmp  = $_FILES['file']['tmp_name'];
        $file_path = $upload_dir . $file_name;

        if (move_uploaded_file($file_tmp, $file_path)) {
            // Prepared statement
            $stmt = $conn->prepare("INSERT INTO user_login (name, email, password, file_path) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssss", $name, $email, $password, $file_path);

            if ($stmt->execute()) {
                $message = "✅ Successfully Registered! You can now login.";
            } else {
                $message = "❌ Error during registration: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $message = "❌ File upload failed!";
        }
    } else {
        $message = "❌ Please choose a file!";
    }
}

// -------------------- LOGIN --------------------
if (isset($_POST['login'])) {
    $email    = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM user_login WHERE email=? LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            $_SESSION['username'] = $row['name'];
            $_SESSION['file']     = $row['file_path'];
        } else {
            $message = "❌ Incorrect password!";
        }
    } else {
        $message = "❌ Email not found!";
    }
    $stmt->close();
}

// -------------------- LOGOUT --------------------
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: loginregistration.php");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>User Login & Registration</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f3f3f3;
      text-align: center;
    }
    form {
      background: white;
      padding: 20px;
      margin: 30px auto;
      width: 300px;
      border-radius: 10px;
      box-shadow: 0 0 10px gray;
    }
    input[type="text"], input[type="email"], input[type="password"], input[type="file"] {
      width: 90%;
      padding: 8px;
      margin: 8px 0;
    }
    input[type="submit"] {
      background: #007bff;
      color: white;
      border: none;
      padding: 10px;
      border-radius: 5px;
      cursor: pointer;
    }
    .message { color: green; margin: 10px; }
  </style>
</head>
<body>

<h2>Login & Registration System</h2>

<?php if (!empty($message)) echo "<p class='message'>$message</p>"; ?>

<?php if (isset($_SESSION['username'])): ?>
  <h3>Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?> 🎉</h3>
  <?php if (!empty($_SESSION['file'])): ?>
    <img src="<?php echo htmlspecialchars($_SESSION['file']); ?>" width="100" height="100" style="border-radius:50%;"><br>
  <?php endif; ?>
  <a href="?logout=true">Logout</a>

<?php else: ?>

  <!-- Signup Form -->
  <form method="post" enctype="multipart/form-data" action="">
    <h3>Signup</h3>
    <input type="text" name="name" placeholder="Full Name" required><br>
    <input type="email" name="email" placeholder="Email" required><br>
    <input type="password" name="password" placeholder="Password" required><br>
    <input type="file" name="file" required><br>
    <input type="submit" name="signup" value="Register">
  </form>

  <!-- Login Form -->
  <form method="post" action="">
    <h3>Login</h3>
    <input type="email" name="email" placeholder="Email" required><br>
    <input type="password" name="password" placeholder="Password" required><br>
    <input type="submit" name="login" value="Login">
  </form>

<?php endif; ?>

</body>
</html>
