<?php
session_start();

if(!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}
$username = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Gallery Page</title>
<style>
body {
    font-family: 'Poppins', sans-serif;
    background: #f0f2f7;
    margin: 0;
    padding: 40px;
}
.container {
    max-width: 960px;
    margin: auto;
    background: #fff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.1);
    position: relative;
}

/* Logout Button */
.logout-btn {
    position: absolute;
    top: 25px;
    right: 25px;
    padding: 10px 18px;
    background: #e74c3c;
    color: white;
    border-radius: 5px;
    text-decoration: none;
    font-weight: 500;
    transition: background 0.3s;
}
.logout-btn:hover { background: #c0392b; }

/* Title */
h2 {
    text-align: center;
    margin-bottom: 25px;
    font-weight: 600;
}

/* Upload Form Section */
.upload-section {
    margin-bottom: 35px; /* space between form and gallery */
    padding: 15px 20px;
    background: #fafafa;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
}
.upload-section form {
    display: flex;
    flex-direction: column;
    gap: 12px;
}
.upload-section select, 
.upload-section input[type="file"], 
.upload-section textarea, 
.upload-section input[type="submit"] {
    padding: 12px;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 15px;
}
.upload-section input[type="submit"] {
    background-color: #3498db;
    color: white;
    cursor: pointer;
    font-weight: 600;
    transition: background 0.3s;
}
.upload-section input[type="submit"]:hover { background-color: #2980b9; }

/* Gallery Section */
.gallery-section {
    padding: 15px 0;
}
.section-title {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
    border-bottom: 2px solid #3498db;
    padding-bottom: 5px;
    color: #2c3e50;
}

.gallery {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 20px;
}

/* Card Styling */
.card {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 4px 18px rgba(0,0,0,0.1);
    overflow: hidden;
    display: flex;
    flex-direction: column;
    transition: transform 0.2s, box-shadow 0.2s;
}
.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}
.card img {
    width: 100%;
    height: auto;
    object-fit: contain; /* ensures full photo is visible */
    display: block;
}
.card-details {
    padding: 12px 15px;
    display: flex;
    flex-direction: column;
}
.card-details p {
    margin: 5px 0;
    font-size: 14px;
    color: #333;
}
.card-details p small { color: #777; }

.delete-btn {
    background: #e74c3c;
    color: #fff;
    border: none;
    padding: 7px 15px;
    border-radius: 6px;
    cursor: pointer;
    font-weight: 500;
    transition: background 0.3s;
    margin-top: 6px;
    align-self: flex-start;
}
.delete-btn:hover { background: #c0392b; }

</style>
</head>
<body>

<div class="container">

<a href="logout.php" class="logout-btn">Logout</a>

<h2>Photo Gallery</h2>

<!-- Upload Section -->
<div class="upload-section">
<form method="post" enctype="multipart/form-data">
    <select name="visibility" required>
        <option value="">-- Select Visibility --</option>
        <option value="Visible">Visible</option>
        <option value="Not Visible">Not Visible</option>
    </select>
    <input type="file" name="photo" required>
    <textarea name="description" placeholder="Enter description..." rows="3"></textarea>
    <input type="submit" name="upload" value="Upload Photo">
</form>
</div>

<!-- Gallery Section -->
<div class="gallery-section">
<?php
$conn = mysqli_connect("localhost", "huzafzif_library", "huzafzif_library", "huzafzif_library");
if (!$conn) die("Database connection failed!");

// Upload Photo
if (isset($_POST['upload'])) {
    $visibility = $_POST['visibility'];
    $description = $_POST['description'];
    $photo = $_FILES['photo']['name'];
    $tmp = $_FILES['photo']['tmp_name'];
    $datetime = date('Y-m-d H:i:s');

    if (!file_exists("uploads")) mkdir("uploads");

    $target = "uploads/" . basename($photo);

    if (move_uploaded_file($tmp, $target)) {
        $query = "INSERT INTO gallery (photo, description, visibility, entry_datetime, username) 
                  VALUES ('$photo', '$description', '$visibility', '$datetime', '$username')";
        mysqli_query($conn, $query);
        echo "<script>alert('Photo uploaded successfully!'); window.location='gallery.php';</script>";
    } else {
        echo "<script>alert('Failed to upload photo!');</script>";
    }
}

// Delete Photo
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $result = mysqli_query($conn, "SELECT * FROM gallery WHERE id=$id AND username='$username'");
    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $file = "uploads/" . $row['photo'];
        if (file_exists($file)) unlink($file);
        mysqli_query($conn, "DELETE FROM gallery WHERE id=$id");
        echo "<script>alert('Photo deleted!'); window.location='gallery.php';</script>";
    } else {
        echo "<script>alert('You can only delete your own photos!');</script>";
    }
}

// Show Gallery
echo "<div class='section-title'>Your Photos</div>";
$res = mysqli_query($conn, "SELECT * FROM gallery WHERE username='$username' ORDER BY id DESC");
echo "<div class='gallery'>";
while ($row = mysqli_fetch_assoc($res)) {
    echo "
    <div class='card'>
        <img src='uploads/{$row['photo']}' alt='Photo'>
        <div class='card-details'>
            <p><strong>Description:</strong> {$row['description']}</p>
            <p><strong>Visibility:</strong> {$row['visibility']}</p>
            <p><small><strong>Uploaded:</strong> {$row['entry_datetime']}</small></p>
            <p><small><strong>By:</strong> {$row['username']}</small></p>";
    if ($row['username'] == $username) {
        echo "<a href='gallery.php?delete={$row['id']}'><button class='delete-btn'>Delete</button></a>";
    }
    echo "</div></div>";
}
echo "</div>";
?>
</div>

</div>
</body>
</html>
