<?php
session_start();

// ==== DATABASE CONNECTION ====
$servername = "localhost";
$dbUsername = "huzafzif_library";
$dbPassword = "huzafzif_library";
$dbname = "huzafzif_library";

$conn = new mysqli($servername, $dbUsername, $dbPassword, $dbname);
if ($conn->connect_error) {
    die("Database Connection Failed: " . $conn->connect_error);
}

// ==== SMTP Settings (Your Namecheap Email) ====
$smtpHost = 'mail.huzaifatech.site';
$smtpPort = 465; // SSL
$smtpUser = 'mirza@huzaifatech.site';
$smtpPass = 'mirza@email';

// ===== Function to send email via SMTP =====
function sendEmailViaSMTP($to, $subject, $bodyHtml, $smtpHost, $smtpPort, $smtpUser, $smtpPass) {
    $context = stream_context_create(['ssl'=>['verify_peer'=>false,'verify_peer_name'=>false]]);
    $fp = @stream_socket_client("ssl://{$smtpHost}:{$smtpPort}", $errno, $errstr, 30, STREAM_CLIENT_CONNECT, $context);
    if (!$fp) return false;

    function readSmtpResponse($fp){
        $resp = '';
        while($line=fgets($fp,515)){
            $resp .= $line;
            if(isset($line[3]) && $line[3]===' ') break;
        }
        return $resp;
    }

    function sendSmtpCmd($fp,$cmd){
        fwrite($fp,$cmd."\r\n");
        return readSmtpResponse($fp);
    }

    $resp = readSmtpResponse($fp);
    if(strpos($resp,'220')!==0) return false;

    sendSmtpCmd($fp,"EHLO ".gethostname());
    sendSmtpCmd($fp,"AUTH LOGIN");
    sendSmtpCmd($fp,base64_encode($smtpUser));
    sendSmtpCmd($fp,base64_encode($smtpPass));
    sendSmtpCmd($fp,"MAIL FROM:<{$smtpUser}>");
    sendSmtpCmd($fp,"RCPT TO:<{$to}>");
    sendSmtpCmd($fp,"DATA");

    $headers = "From: Huzaifa Mirza <{$smtpUser}>\r\n";
    $headers .= "To: {$to}\r\n";
    $headers .= "Subject: {$subject}\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n\r\n";

    fwrite($fp,$headers.$bodyHtml."\r\n.\r\n");
    readSmtpResponse($fp);
    sendSmtpCmd($fp,"QUIT");
    fclose($fp);

    return true;
}

// ===== LOGIN PROCESS =====
if ($_SERVER['REQUEST_METHOD'] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM app WHERE email=? AND password=?");
    $stmt->bind_param("ss",$email,$password);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    if($row){
        $_SESSION['username'] = $row['username'];
        $_SESSION['email'] = $row['email'];
        $_SESSION['photo'] = $row['photo'];

        // ===== Email Notification =====
        $subject = "🔒 New Login Detected - Mirza Society";
        $message = "
        <html>
        <body style='font-family:Arial,sans-serif;background:#f9f9f9;padding:20px;'>
            <div style='max-width:500px;margin:auto;background:#fff;padding:20px;border-radius:10px;box-shadow:0 0 10px rgba(0,0,0,0.1);'>
                <h2 style='color:#4CAF50;text-align:center;'>Welcome to Mirza Society, {$row['username']}!</h2>
                <p style='font-size:15px;color:#333;'>A new login was detected using your account: <b>{$row['email']}</b>.</p>
                <p style='font-size:15px;color:#333;'>If this was you, you can safely ignore this message. If not, please reset your password immediately.</p>
                <hr style='border:none;border-top:1px solid #eee;margin:20px 0;'>
                <p style='font-size:12px;color:#777;text-align:center;'>This email was sent automatically by Mirza Society — powered by Huzaifa.</p>
            </div>
        </body>
        </html>";

        sendEmailViaSMTP($email,$subject,$message,$smtpHost,$smtpPort,$smtpUser,$smtpPass);

        // Redirect to welcome.php
        header("Location: welcome.php");
        exit;
    } else {
        $error = "Invalid Email or Password!";
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Login Page</title>
<style>
    body {
        font-family: 'Poppins', sans-serif;
        background: linear-gradient(135deg, #f3f4f7, #d9e4f5);
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        margin: 0;
        flex-direction: column;
    }

    /* 🌍 Public Pics Button */
    .public-btn {
        background: linear-gradient(45deg, #28a745, #34d058);
        color: white;
        padding: 12px 25px;
        text-decoration: none;
        border-radius: 30px;
        font-weight: bold;
        font-size: 16px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.2);
        transition: all 0.3s ease;
        margin-bottom: 20px;
        display: inline-block;
    }
    .public-btn:hover {
        background: linear-gradient(45deg, #34d058, #28a745);
        box-shadow: 0 6px 15px rgba(40,167,69,0.4);
        transform: scale(1.05);
    }

    .container {
        background-color: #fff;
        padding: 30px 40px;
        border-radius: 15px;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        width: 350px;
        text-align: center;
    }

    h2 {
        margin-bottom: 25px;
        color: #333;
    }

    input[type="email"], input[type="password"] {
        width: 90%;
        padding: 10px;
        margin: 8px 0;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 14px;
    }

    input[type="submit"] {
        width: 95%;
        background-color: #3897f0;
        color: white;
        padding: 10px;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        margin-top: 15px;
        font-weight: bold;
    }

    input[type="submit"]:hover {
        background-color: #2f80ed;
    }

    p {
        margin-top: 15px;
        font-size: 13px;
    }

    a {
        text-decoration: none;
        color: #3897f0;
        font-weight: 500;
    }

    a:hover {
        text-decoration: underline;
    }

    .error {
        color: red;
        font-size: 13px;
        margin-top: 10px;
    }
</style>
</head>
<body>

<!-- 🌍 Public Pics Button (Top Section) -->
<a href="public.php" class="public-btn">🌍 Show Public Pics</a>

<div class="container">
    <h2>Login</h2>
    <form method="post">
        <input type="email" name="email" placeholder="Email" required><br>
        <input type="password" name="password" placeholder="Password" required><br>
        <input type="submit" value="Login">
    </form>
    <p>Don't have an account? <a href="signup.php">Sign Up</a></p>

    <?php
    if(isset($error)){
        echo "<div class='error'>$error</div>";
    }
    ?>
</div>

</body>
</html>
