<?php
session_start();

// Check if user is logged in and session username is valid
if(!isset($_SESSION['username']) || empty($_SESSION['username'])){
    header("Location: login.php");
    exit();
}

$username = $_SESSION['username'];

$conn = mysqli_connect("localhost", "huzafzif_library", "huzafzif_library", "huzafzif_library");
if(!$conn){
    die("Connection failed: " . mysqli_connect_error());
}

// Logout functionality
if(isset($_GET['logout'])){
    session_unset();
    session_destroy();
    header("Location: welcome.php"); // redirect to welcome page
    exit();
}

if(isset($_POST['save'])){
    $prefix = $_POST['prefix'];
    $fname = $_POST['firstname'];
    $lname = $_POST['lastname'];
    $mobile = $_POST['mobile'];
    $email = $_POST['email'];
    $id = $_POST['id'];

    $photo = '';
    if(isset($_FILES['photo']) && $_FILES['photo']['name'] != ''){
        $folder = "uploads/";
        if(!is_dir($folder)){ mkdir($folder); }
        $photo = $folder . basename($_FILES['photo']['name']);
        move_uploaded_file($_FILES['photo']['tmp_name'], $photo);
    } else if(!$id) { 
        echo "<script>alert('Please select a profile photo.'); window.history.back();</script>";
        exit();
    }

    $mobile = ltrim($mobile, '+');

    if($id != ''){
        if($photo != ''){
            $sql = "UPDATE contacts SET prefix='$prefix', firstname='$fname', lastname='$lname', mobile='$mobile', email='$email', photo='$photo' WHERE id='$id' AND username='$username'";
        } else {
            $sql = "UPDATE contacts SET prefix='$prefix', firstname='$fname', lastname='$lname', mobile='$mobile', email='$email' WHERE id='$id' AND username='$username'";
        }
    } else {
        $sql = "INSERT INTO contacts (username, prefix, firstname, lastname, mobile, email, photo) 
                VALUES ('$username','$prefix','$fname','$lname','$mobile','$email','$photo')";
    }

    mysqli_query($conn, $sql);
    header("Location: mycontacts.php");
    exit();
}

$editData = null;
if(isset($_GET['edit'])){
    $id = $_GET['edit'];
    $getData = mysqli_query($conn, "SELECT * FROM contacts WHERE id='$id' AND username='$username'");
    $editData = mysqli_fetch_assoc($getData);
}

$result = mysqli_query($conn, "SELECT * FROM contacts WHERE username='$username' ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<title>My Contacts</title>
<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');

:root {
    --primary: #6a11cb;
    --secondary: #2575fc;
    --success: #00c896;
    --wa: #25D366;
    --warning: #ffb300;
    --bg: #f4f7fb;
}

body {
    font-family: 'Poppins', sans-serif;
    background: var(--bg);
    margin: 0;
    padding: 0;
}

.header {
    background: linear-gradient(90deg, var(--primary), var(--secondary));
    color: #fff;
    text-align: center;
    padding: 20px;
    font-size: 26px;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    position: sticky;
    top: 0;
    z-index: 100;
}

.logout-btn {
    position: absolute;
    right: 20px;
    top: 15px;
    background: linear-gradient(90deg, #ff416c, #ff4b2b);
    color: #fff;
    padding: 10px 18px;
    border-radius: 10px;
    text-decoration: none;
    font-size: 14px;
    font-weight: 600;
    box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
}
.logout-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(255,65,108,0.3);
}

.container {
    width: 90%;
    max-width: 1000px;
    margin: 40px auto;
    background: #fff;
    border-radius: 18px;
    padding: 30px 40px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

h2 {
    text-align: center;
    margin-bottom: 30px;
    color: #222;
    font-weight: 600;
    font-size: 26px;
}

form {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 15px;
    margin-bottom: 40px;
}

input, select {
    padding: 12px 14px;
    border-radius: 10px;
    border: 1px solid #dbe3f0;
    background: #fafafa;
    font-size: 15px;
    transition: all 0.3s ease;
}

input:focus, select:focus {
    border-color: var(--secondary);
    box-shadow: 0 0 10px rgba(37,117,252,0.2);
    background: white;
    outline: none;
}

button {
    grid-column: span 2;
    padding: 14px;
    border: none;
    border-radius: 12px;
    background: linear-gradient(90deg, var(--primary), var(--secondary));
    color: white;
    font-size: 17px;
    font-weight: 600;
    cursor: pointer;
    position: relative;
    overflow: hidden;
    transition: all 0.4s ease;
}

button::before {
    content: '';
    position: absolute;
    top: 0;
    left: -75%;
    width: 50%;
    height: 100%;
    background: rgba(255,255,255,0.3);
    transform: skewX(-25deg);
    transition: 0.5s;
}

button:hover::before { left: 125%; }
button:hover { transform: translateY(-2px); box-shadow: 0 8px 20px rgba(106,17,203,0.3); }

.user-list {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.user-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: #fff;
    padding: 15px 20px;
    border-radius: 18px;
    box-shadow: 0 6px 25px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.user-row:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.12);
}

.user-info {
    display: flex;
    align-items: center;
    gap: 15px;
}

.user-info img {
    width: 70px;
    height: 70px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid #eee;
}

.details h3 {
    margin: 0;
    font-size: 18px;
    font-weight: 600;
    color: #333;
}

.user-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.user-actions a {
    padding: 10px 16px;
    border-radius: 10px;
    color: #fff;
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
}

.user-actions a::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: rgba(255,255,255,0.25);
    transition: all 0.4s ease;
}

.user-actions a:hover::before { left: 100%; }
.user-actions a:hover { transform: translateY(-2px); }

.call { background: var(--secondary); }
.whatsapp { background: var(--wa); }
.email { background: var(--warning); color: #222; }
.edit { background: var(--success); }

@media(max-width:700px){
    .user-row { flex-direction: column; align-items: flex-start; gap: 10px; }
    .user-actions { justify-content: flex-start; }
    button { grid-column: span 1; }
}
</style>
</head>
<body>

<div class="header">
    📇 My Contact Manager
    <a href="?logout=true" class="logout-btn">Logout</a>
</div>

<div class="container">
    <h2><?php echo isset($editData) ? "Update Contact" : "Add New Contact"; ?></h2>

    <form method="POST" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?php echo $editData['id'] ?? ''; ?>">
        <select name="prefix" required>
            <option value="">Select Prefix</option>
            <option <?php if(($editData['prefix'] ?? '')=='Mr.') echo 'selected'; ?>>Mr.</option>
            <option <?php if(($editData['prefix'] ?? '')=='Mrs.') echo 'selected'; ?>>Mrs.</option>
            <option <?php if(($editData['prefix'] ?? '')=='Miss') echo 'selected'; ?>>Miss</option>
            <option <?php if(($editData['prefix'] ?? '')=='Dr.') echo 'selected'; ?>>Dr.</option>
        </select>
        <input type="text" name="firstname" placeholder="First Name" value="<?php echo $editData['firstname'] ?? ''; ?>" required>
        <input type="text" name="lastname" placeholder="Last Name" value="<?php echo $editData['lastname'] ?? ''; ?>" required>
        <input type="text" name="mobile" placeholder="+92xxxxxxxxxx" pattern="\+92[0-9]{10}" title="Enter number in +92 format followed by 10 digits" value="<?php echo isset($editData['mobile']) ? '+'.$editData['mobile'] : ''; ?>" required>
        <input type="email" name="email" placeholder="Email" value="<?php echo $editData['email'] ?? ''; ?>" required>
        <input type="file" name="photo" accept="image/*" <?php echo isset($editData['photo']) ? '' : 'required'; ?>>
        <button type="submit" name="save"><?php echo isset($editData) ? "Update Contact" : "Save Contact"; ?></button>
    </form>

    <div class="user-list">
        <?php while($row = mysqli_fetch_assoc($result)){ ?>
        <div class="user-row">
            <div class="user-info">
                <img src="<?php echo $row['photo'] ?: 'https://via.placeholder.com/70'; ?>" alt="Profile">
                <div class="details">
                    <h3><?php echo $row['prefix'].' '.$row['firstname'].' '.$row['lastname']; ?></h3>
                </div>
            </div>
            <div class="user-actions">
                <a href="tel:+<?php echo $row['mobile']; ?>" class="call">📞 Call</a>
                <a href="https://wa.me/<?php echo $row['mobile']; ?>" target="_blank" class="whatsapp">💬 WhatsApp</a>
                <a href="mailto:<?php echo $row['email']; ?>" class="email">✉️ Email</a>
                <a href="mycontacts.php?edit=<?php echo $row['id']; ?>" class="edit">✏️ Edit</a>
            </div>
        </div>
        <?php } ?>
    </div>
</div>

</body>
</html>
