<?php
session_start();

$conn = mysqli_connect("localhost", "huzafzif_library", "huzafzif_library", "huzafzif_library");
if(!$conn){
    die("Connection failed: " . mysqli_connect_error());
}

if(!isset($_SESSION['username'])){
    header("location: login.php");
    exit();
}

$username = $_SESSION['username'];

if(isset($_POST['submit'])){
    $date = $_POST['date'];
    $fajar = $_POST['fajar'];
    $zuhr = $_POST['zuhr'];
    $asr = $_POST['asr'];
    $maghrib = $_POST['maghrib'];
    $esha = $_POST['esha'];

    $query = "INSERT INTO namaz_record (username, date, fajar, zuhr, asr, maghrib, esha)
              VALUES ('$username', '$date', '$fajar', '$zuhr', '$asr', '$maghrib', '$esha')";
    mysqli_query($conn, $query);
}

$result = mysqli_query($conn, "SELECT * FROM namaz_record WHERE username='$username' ORDER BY date DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Namaz Record</title>
    <style>
        body{
            background: linear-gradient(135deg, #e3f2fd, #ffffff);
            font-family: 'Poppins', sans-serif;
            padding: 40px;
            text-align: center;
        }
        h2{
            color: #0d6efd;
            margin-bottom: 30px;
            font-size: 28px;
            text-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }
        form{
            background: rgba(255,255,255,0.95);
            padding: 30px 40px;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            display: inline-block;
            margin-bottom: 40px;
            backdrop-filter: blur(5px);
        }
        input[type="date"]{
            padding: 10px 14px;
            border: 1px solid #ccc;
            border-radius: 12px;
            margin-bottom: 20px;
            font-size: 16px;
        }
        .table-inputs{
            display: grid;
            grid-template-columns: 150px auto;
            row-gap: 12px;
            align-items: center;
            text-align: left;
        }
        .radio-group{
            display: flex;
            gap: 25px;
            justify-content: center;
        }
        label{
            font-weight: 600;
            color: #333;
            font-size: 16px;
        }
        input[type="radio"]{
            transform: scale(1.3);
            accent-color: #0078ff;
        }
        .btn{
            background: linear-gradient(90deg, #0078ff, #005bcc);
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 14px;
            cursor: pointer;
            margin: 12px;
            font-weight: 600;
            font-size: 15px;
            transition: 0.3s ease;
            box-shadow: 0 5px 12px rgba(0,0,0,0.2);
        }
        .btn:hover{
            transform: translateY(-2px);
            box-shadow: 0 7px 18px rgba(0,0,0,0.25);
        }
        .btn-green{
            background: linear-gradient(90deg, #28a745, #1f8736);
        }
        table{
            width: 90%;
            margin: 25px auto;
            border-collapse: collapse;
            background: white;
            border-radius: 14px;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }
        th, td{
            padding: 14px;
            border: 1px solid #ddd;
            font-size: 15px;
        }
        th{
            background: #0078ff;
            color: white;
            font-weight: 600;
        }
        tr:nth-child(even){
            background: #f2f8ff;
        }
        tr:hover{
            background: #e8f0fe;
        }
        .button-group{
            text-align: center;
            margin-top: 25px;
        }
    </style>
</head>
<body>

<h2>Namaz Record for <?php echo $_SESSION['username']; ?></h2>

<form method="post">
    <label>Select Date:</label><br>
    <input type="date" name="date" required><br><br>

    <div class="table-inputs">
        <?php
        $prayers = ['Fajar', 'Zuhr', 'Asr', 'Maghrib', 'Esha'];
        foreach($prayers as $p){
            echo "
            <label>$p:</label>
            <div class='radio-group'>
                <label><input type='radio' name='".strtolower($p)."' value='Yes' required> Yes</label>
                <label><input type='radio' name='".strtolower($p)."' value='No'> No</label>
            </div>
            ";
        }
        ?>
    </div>

    <div class="button-group">
        <input type="submit" name="submit" value="Add Record" class="btn">
    </div>
</form>

<?php
echo '<table>
    <tr>
        <th>Date</th>
        <th>Username</th>
        <th>Fajar</th>
        <th>Zuhr</th>
        <th>Asr</th>
        <th>Maghrib</th>
        <th>Esha</th>
    </tr>';

while($row = mysqli_fetch_assoc($result)) {
    echo '<tr>
        <td>'.$row['date'].'</td>
        <td>'.$row['username'].'</td>
        <td>'.$row['fajar'].'</td>
        <td>'.$row['zuhr'].'</td>
        <td>'.$row['asr'].'</td>
        <td>'.$row['maghrib'].'</td>
        <td>'.$row['esha'].'</td>
    </tr>';
}

echo '</table>';
?>

<div class="button-group">
    <a href="logout.php" class="btn btn-green">Logout</a>
    <a href="login.php" class="btn">Back to Home</a>
</div>

</body>
</html



