<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Public Gallery</title>
<style>
    body {
        font-family: 'Poppins', sans-serif;
        background: #eef1f5;
        margin: 0;
        padding: 40px;
    }
    .container {
        max-width: 800px;
        margin: auto;
        background: #fff;
        padding: 25px;
        border-radius: 15px;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
        color: #333;
    }
    .gallery {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
    }
    .card {
        background: #fafafa;
        border: 1px solid #ddd;
        padding: 10px;
        border-radius: 10px;
        text-align: center;
        box-shadow: 0 0 8px rgba(0,0,0,0.1);
    }
    .card img {
        width: 100%;
        height: 160px;
        object-fit: cover;
        border-radius: 10px;
        margin-bottom: 8px;
    }
    p { font-size: 14px; color: #333; }
    a.back-btn {
        display: inline-block;
        text-decoration: none;
        background: #007bff;
        color: white;
        padding: 8px 15px;
        border-radius: 6px;
        margin-top: 20px;
    }
    a.back-btn:hover { background: #0056b3; }
</style>
</head>
<body>

<div class="container">
    <h2>📸 Public Gallery</h2>

    <div class="gallery">
        <?php
        $conn = mysqli_connect("localhost", "huzafzif_library", "huzafzif_library", "huzafzif_library");
        if (!$conn) { die("Database connection failed!"); }

        $res = mysqli_query($conn, "SELECT * FROM gallery WHERE visibility='Visible' ORDER BY id DESC");
        while ($row = mysqli_fetch_assoc($res)) {
            echo "
            <div class='card'>
                <img src='uploads/{$row['photo']}' alt='Photo'>
                <p><strong>{$row['description']}</strong></p>
                <p><small>Uploaded: {$row['entry_datetime']}</small></p>
            </div>
            ";
        }
        ?>
    </div>

    <div style="text-align:center;">
        <a href='login.php' class='back-btn'>Back to Login</a>
    </div>
</div>

</body>
</html>
