<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Signup Page</title>
<style>
    body {
        font-family: 'Poppins', sans-serif;
        background: linear-gradient(135deg, #f3f4f7, #d9e4f5);
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column; /* so video can appear below form */
        min-height: 100vh;
        margin: 0;
    }
    .container {
        background-color: #fff;
        padding: 30px 40px;
        border-radius: 15px;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        width: 350px;
        text-align: center;
        margin-bottom: 20px; /* space for video */
    }
    h2 {
        margin-bottom: 25px;
        color: #333;
    }
    input[type="text"], input[type="email"], input[type="password"], input[type="file"] {
        width: 90%;
        padding: 10px;
        margin: 8px 0;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 14px;
    }
    input[type="submit"] {
        width: 95%;
        background-color: #3897f0;
        color: white;
        padding: 10px;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        margin-top: 15px;
        font-weight: bold;
    }
    input[type="submit"]:hover {
        background-color: #2f80ed;
    }
    p {
        margin-top: 15px;
        font-size: 13px;
    }
    a {
        text-decoration: none;
        color: #3897f0;
        font-weight: 500;
    }
    a:hover {
        text-decoration: underline;
    }
    /* Responsive video */
    .video-container {
        position: relative;
        width: 100%;
        max-width: 400px;
        height: 0;
        padding-bottom: 56.25%; /* 16:9 aspect ratio */
        margin: 0 auto 0 auto;
    }
    .video-container iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 50%;
    }
</style>
</head>
<body>

<div class="container">
    <h2>Create Account</h2>
    <form method="post" enctype="multipart/form-data">
        <input type="text" name="username" placeholder="Username" required><br>
        <input type="email" name="email" placeholder="Email" required><br>
        <input type="password" name="password" placeholder="Password" required><br>
        <input type="file" name="photo" required><br>
        <input type="submit" value="Sign Up">
    </form>
    <p>Already have an account? <a href="login.php">Login</a></p>
</div>

<!-- First Responsive YouTube tutorial -->
<div class="video-container">
    <iframe src="https://www.youtube.com/embed/dun63rPIAd0" 
        title="YouTube tutorial" 
        frameborder="0" 
        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
        allowfullscreen>
    </iframe>
</div>

<!-- Space between videos -->
<div style="height: 40px;"></div>

<!-- Second Responsive YouTube tutorial -->
<div class="video-container">
    <iframe src="https://www.youtube.com/embed/lVWeCqvaTW0"
        title="Second YouTube tutorial"
        frameborder="0"
        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen>
    </iframe>
</div>
<!-- Third Responsive YouTube tutorial -->
<div class="video-container">
    <iframe src="https://www.youtube.com/embed/PNf6FgsgtdM"
        title="Second YouTube tutorial"
        frameborder="0"
        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen>
    </iframe>
</div>

<?php
$con = mysqli_connect("localhost", "huzafzif_library", "huzafzif_library", "huzafzif_library");

if ($_SERVER['REQUEST_METHOD'] == "POST") {
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $photo = $_FILES['photo']['name'];
    $tmp = $_FILES['photo']['tmp_name'];

    // Check if email already exists
    $check = mysqli_query($con, "SELECT * FROM app WHERE email='$email'");
    if (mysqli_num_rows($check) > 0) {
        echo "<script>alert('Email already exists! Please login.'); window.location='login.php';</script>";
    } else {
        // uploads folder check
        if (!file_exists("uploads")) {
            mkdir("uploads");
        }

        // Move file and insert data
        if (move_uploaded_file($tmp, "uploads/" . $photo)) {
            $query = "INSERT INTO app (username, email, password, photo) VALUES ('$username', '$email', '$password', '$photo')";
            mysqli_query($con, $query);
            echo "<script>alert('Signup Successful!'); window.location='login.php';</script>";
        } else {
            echo "<script>alert('File upload failed!');</script>";
        }
    }
}
?>

</body>
</html>    