<?php
session_start();

// Agar user login nahi hai to login page pe bhej do
if(!isset($_SESSION['username'])){
    header("location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome Page</title>
    <style>
        body {
            background: linear-gradient(135deg, #e3f2fd, #ffffff);
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
            margin: 0;
            padding: 40px 10px;
        }

        .container {
            background: #fff;
            width: 95%;
            max-width: 900px;
            padding: 40px 30px;
            border-radius: 20px;
            text-align: center;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }

        h2 {
            margin-bottom: 10px;
            color: #333;
        }

        h3 {
            color: #0078ff;
            margin-bottom: 30px;
        }

        .sections {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 25px;
            margin-bottom: 30px;
        }

        .card {
            background: #f8f9fa;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            width: 260px;
            height: 190px;
            padding: 20px;
            text-align: center;
            transition: 0.3s;
            cursor: pointer;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }

        .card img {
            width: 65px;
            height: 65px;
            margin-bottom: 15px;
        }

        .card h4 {
            color: #0078ff;
            font-size: 18px;
            margin-bottom: 5px;
        }

        .card p {
            color: #666;
            font-size: 14px;
            line-height: 1.4;
        }

        .logout-btn {
            display: inline-block;
            margin-top: 10px;
            padding: 10px 25px;
            background: #dc3545;
            color: #fff;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-weight: 600;
            text-decoration: none;
            transition: 0.3s;
        }

        .logout-btn:hover {
            background: #c82333;
        }

        @media(max-width: 768px) {
            .card {
                width: 80%;
                height: auto;
                padding: 25px 20px;
            }

            .sections {
                gap: 20px;
            }
        }

        @media(max-width: 480px) {
            .container {
                padding: 25px 15px;
            }

            h2 {
                font-size: 22px;
            }

            h3 {
                font-size: 18px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Welcome!</h2>
        <p>You are successfully logged in as:</p>
        <h3><?php echo $_SESSION['username']; ?></h3>

        <div class="sections">
            <a href="namaz.php" style="text-decoration:none;">
                <div class="card">
                    <img src="https://cdn-icons-png.flaticon.com/512/3103/3103446.png" alt="Namaz Icon">
                    <h4>Namaz Record</h4>
                    <p>View and manage your prayer records</p>
                </div>
            </a>

            <a href="gallery.php" style="text-decoration:none;">
                <div class="card">
                    <img src="https://cdn-icons-png.flaticon.com/512/3342/3342137.png" alt="Gallery Icon">
                    <h4>Photo Gallery</h4>
                    <p>Upload and manage your photo collection</p>
                </div>
            </a>

            <!-- New My Contacts Card -->
            <a href="mycontacts.php" style="text-decoration:none;">
                <div class="card">
                    <img src="https://cdn-icons-png.flaticon.com/512/1250/1250689.png" alt="Contacts Icon">
                    <h4>My Contacts</h4>
                    <p>View and manage your contact list</p>
                </div>
            </a>
        </div>

        <a href="logout.php" class="logout-btn">Logout</a>
    </div>
</body>
</html>
