<?php
// backend/api/update_task.php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../config/db.php';

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->id)) {
    try {
        // Dynamic update query construction could be better, but we know the fields
        // We will update title, description, and is_completed if they are present
        
        $query = "UPDATE tasks SET ";
        $params = [];
        
        if (isset($data->title)) {
            $query .= "title = :title, ";
            $params[':title'] = htmlspecialchars(strip_tags($data->title));
        }
        
        if (isset($data->description)) {
            $query .= "description = :description, ";
            $params[':description'] = htmlspecialchars(strip_tags($data->description));
        }
        
        if (isset($data->is_completed)) {
            $query .= "is_completed = :is_completed, ";
            $params[':is_completed'] = intval($data->is_completed);
        }
        
        // Remove trailing comma and space
        $query = rtrim($query, ", ");
        
        $query .= " WHERE id = :id";
        $params[':id'] = intval($data->id);

        if (count($params) > 1) { // At least one field to update besides ID
            $stmt = $conn->prepare($query);
            
            if ($stmt->execute($params)) {
                http_response_code(200);
                echo json_encode(["status" => "success", "message" => "Task updated."]);
            } else {
                http_response_code(503);
                echo json_encode(["status" => "error", "message" => "Unable to update task."]);
            }
        } else {
             http_response_code(400);
             echo json_encode(["status" => "error", "message" => "No fields to update."]);
        }
        
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Task ID is missing."]);
}
?>
